;
; WiC64 Test Kernal for loading directly .prg from http server.
;
; Replaces "!" at start of LOAD "!xxx" command with the default server (http://x.wic64.net/prg/).
;
; Changes F-keys for loading WiC64 NET start program
;
; F1 = LOAD"!START.PRG"
; F2 = LOAD"!DIR.PRG"
; F3 = LOAD"!
; F4 = currently unused
; F5 = RUN:
; F6 = SYS49152:
; F7 = LIST:
; F8 = PRINT PEEK (
;
; It is currently more of a technical demo and not a real core for practical use!
;
; But this code is for free use and we would be very happy about extensions. For example:
;  - http-save
;  - set server
;  - ti-sync
;  - autostart
;  - and much more.
;
; If you have any questions, we will be happy to help and advise you. Please write to contact@wic64.com.
;


!to "wic64kernal.bin",plain

 Pointerlow = $a4
Pointerhigh = $a5
    Counter = $a6
     memend = $ae
     length = $c1
  datastart = $c3

*=$e000
 !bin "kernal.bin"

*=$e479
 !text " ** COMMODORE WIC64 BASIC V2 **"

*=$e5e7              ; Keyboard abfrage patchen
   jsr FKeys

*=$ea69              ; Tape Motor $C0 killen
   nop
   nop

*=$eebb
sendloadheader
   lda #$ff          ; Datenrichtung Port B Ausgang
   sta $dd03
   lda $dd00
   ora #$04          ; PA2 auf HIGH = ESP im Empfangsmodus
   sta $dd00
   lda $dd0d
   jsr send_string   ; http://irgendwas an den ESP Senden
   rts

load
   lda #$00          ; Datenrichtung Port B Eingang
   sta $dd03
   lda $dd00
   and #251          ; PA2 auf LOW = ESP im Sendemodus
   sta $dd00

   jsr read_byte     ; Dummy Byte - um IRQ im ESP anzuschubsen

   jsr read_byte
   sta $fa
   jsr read_byte
   sta $fb           ; Länge der Datenübertragung Byte 1 und 2

   lda $fa
   bne noloaderror
   lda $fb
   beq +
   cmp #$02
   beq +
   jmp noloaderror

+
   sec
   lda #$04
   rts

noloaderror
   jsr read_byte
   sta $fc
   sta datastart
   sta length+1      ; Load Adresse Start C1 bzw. Ende C3
   jsr read_byte
   sta $fd
   sta datastart+1
   sta length+1

   ldx $fb           ; low byte
xloop
   ldy #$00
goread
   jsr read_byte
   sta ($fc),y
   iny
   bne ycont
   inc $fd
ycont
   dex
   bne goread
   dec $fa
   lda $fa
   cmp #$ff
   bne goread

   sty datastart
   lda $fd
   sta $c4

cleanup              ; ESP in Lesemodus schalten
   lda #$ff          ; Datenrichtung Port B Ausgang
   sta $dd03
   lda $dd00
   ora #$04          ; PA2 auf HIGH = ESP im Empfangsmodus
   sta $dd00
   lda #$00
   clc
   rts

save
   lda #$01
   sta datastart
   lda #$08
   sta datastart+1

   sec
   lda memend
   sbc datastart     ; Pointer Memory End load save
   sbc #1
   sta length

   lda memend+1
   sbc datastart+1
   sta length+1

   ldy #00           ; Filenamen senden
-
   lda ($bb),y
   iny
   cpy $b7
   bne -
   clc
   rts

send_string          ; httpcommand: !text "W",$00,$00,$01
   lda #"W"
   jsr write_byte
   lda $b7
   clc
   adc #$04
   jsr write_byte
   lda #$00
   jsr write_byte
   lda #$01
   jsr write_byte

   ldy #00           ; Filenamen senden
-
   lda ($bb),y
   jsr charconvert
   jsr write_byte
   iny
   cpy $B7
   bne -
   rts

write_byte
   sta $dd01         ; Bit 0..7: Userport Daten PB 0-7 schreiben
   lda #$10
-
   bit $dd0d
   beq -             ; Warten auf NMI FLAG2 = Byte wurde gelesen vom ESP
   rts

read_byte
   lda #$10
-
   bit $dd0d
   beq -             ; Warten auf NMI FLAG2 = Byte wurde gelesen vom ESP

   lda $dd01
   rts

charconvert
   cmp #$20
   bne +
   lda #$2e
+
   cmp #$c0
   bcs +++
   cmp #$40
   bcs ++
   rts
++
   ora #%00100000
   rts
+++
   and #%10000000
   rts

FKeys
   jsr $e5b4         ; Originale Keyboard Abfrage ausführen
   cmp #$8d
   bcs +             ; Größer als F8
   cmp #$85
   bcc +             ; Kleiner als F1
   sbc #$85
   tax
   lda FTablelow,x   ; Zeiger auf F-Tasten Tabelle setzen
   sta Pointerlow
   lda FTablehigh,x
   sta Pointerhigh

   lda #$00
   sta Counter
-
   ldy Counter
   lda (Pointerlow),y
   beq +             ; Ausgabe beenden
   cmp #$0d          ; Auf ENTER gestoßen - Enter als letzte Taste dem Tastaturpuffer übermitteln
   beq +

   jsr $E716         ; CHROUT - Ein Zeichen ausgeben
   inc Counter
   jmp -
+
   rts

FTablelow
 !byte <F1,<F3,<F5,<F7,<F2,<F4,<F6,<F8
FTablehigh
 !byte >F1,>F3,>F5,>F7,>F2,>F4,>F6,>F8

F1
!text "LOAD",$22,"!START.PRG",$22,$0d
F2
!text "LOAD",$22,"!DIR.PRG",$22,$0d
F3
!text "LOAD",$22,"!",$22,$14,0
F4
!text 0
F5
!text "RUN:",$0d
F6
!text "SYS49152:",0
F7
!text "LIST:",$0d
F8
!text "PRINT PEEK (",0


*=$f541              ; jsr $f817 Tape play key check removed
   ldy #$01
   lda datastart
   sta ($b2),y
   iny
   lda datastart+1
   sta ($b2),y
   jsr sendloadheader
   jmp $f56c

*=$f5a5              ; jsr $f84a - load data from tape
   jsr load

*=$f664              ; jsr $f838 Tape record key check removed
   jsr $F68F         ; 'SAVING' (Name) ausgeben
   jsr save
   clc
   rts

*=$fd6c              ; Fast Reset Patch , no RAM Check
   jsr $fd02         ; CBM80 Cartige eingesteckt ?
   beq cbm80

   ldx #$00
   ldy #$a0          ; $a000 Ende des Speichers für Basic
   jmp $fd8c

cbm80
   ldx #$00
   ldy #$80          ; $8000 Ende des Speichers für Basic
   jmp $fd8c
